from Environment.Environments.Phyre.level_builder import PHYRETemplate
from Environment.Environments.Phyre.objects import Ball, Basket, Platform
import numpy as np


class BalanceBeam(PHYRETemplate):
    def __init__(self):
        super().__init__()

    def build_task(self):
        self.name = "balance_beam"
        self.description = "The green ball should not fall off the balance beam"

        # Set level properties
        self.target_object = "green_ball"
        self.goal_object = "blue_platform"
        self.action_objects = ["red_ball"]

        # Ball attributes are x, y, radius, color, dynamic
        # Platform attributes are x, y, length, angle, color, dynamic
        # Basket attributes are x, y, scale, color, dynamic
        # Set fixed attributes
        self.objects = {
            "green_ball": Ball(0, -2, 1, "green", True),
            "red_ball": Ball(0, 0, 0.4, "red", True),
            "blue_platform": Platform(0, 2, 4, 0, "blue", True),
            "fulcrum_ball": Ball(0, -4, 1, "gray", False),
        }

        # randomly set platform within range
        self.objects["blue_platform"].length = np.random.uniform(0.3, 0.45) * 10
        self.objects["blue_platform"].x = np.random.uniform(-0.25, 0.25) * 10

        # Randomly set red ball starting position
        # This only matters for passive mode
        self.objects["red_ball"].x = np.random.uniform(-4.5, 4.5)
        self.objects["red_ball"].y = np.random.uniform(-1, 4)
